/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ITopContentTypesProvider;
import com.aptana.editor.common.contentassist.ContentAssistant;
import com.aptana.editor.common.contentassist.ICommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.SimpleTextHover;
import com.aptana.editor.common.hover.AbstractCommonTextHover;
import com.aptana.editor.common.hover.ThemedInformationControl;
import com.aptana.editor.common.internal.formatter.CommonMultiPassContentFormatter;
import com.aptana.editor.common.internal.hover.TextHoverDescriptor;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.spelling.MultiRegionSpellingReconcileStrategy;
import com.aptana.editor.common.text.CommonDoubleClickStrategy;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.common.text.reconciler.CommonPresentationReconciler;
import com.aptana.editor.common.text.reconciler.CommonReconciler;
import com.aptana.editor.common.text.reconciler.CommonReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.CompositeReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.IBatchReconcilingStrategy;
import com.aptana.editor.hover.CommonAnnotationHover;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.spelling.SpellingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonSourceViewerConfiguration
extends TextSourceViewerConfiguration
implements ITopContentTypesProvider {
    public static final int CONTENT_ASSIST_OFF_DELAY = -1;
    public static final int NO_CONTENT_ASSIST_DELAY = 0;
    public static final int DEFAULT_CONTENT_ASSIST_DELAY = 200;
    public static final int LONG_CONTENT_ASSIST_DELAY = 1000;
    private boolean disableBackgroundReconciler = false;
    public static final String CONTENTTYPE_HTML_PREFIX = "com.aptana.contenttype.html";
    private AbstractThemeableEditor fTextEditor;
    private CommonDoubleClickStrategy fDoubleClickStrategy;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private IEclipsePreferences.IPreferenceChangeListener fAutoActivationListener;
    protected CommonReconciler fReconciler;
    List<IContentAssistProcessor> fCAProcessors = new ArrayList<IContentAssistProcessor>();

    protected CommonSourceViewerConfiguration(IPreferenceStore preferenceStore, AbstractThemeableEditor editor) {
        super(preferenceStore);
        this.fTextEditor = editor;
        this.disableBackgroundReconciler = Boolean.parseBoolean(EclipseUtil.getSystemProperty((String)"studio.disableBackgroundReconciler"));
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fDoubleClickStrategy = null;
        if (this.fReconciler != null) {
            this.fReconciler.dispose();
            this.fReconciler = null;
        }
        if (this.fAutoActivationListener != null) {
            InstanceScope.INSTANCE.getNode("com.aptana.editor.common").removePreferenceChangeListener(this.fAutoActivationListener);
            this.fAutoActivationListener = null;
        }
        if (this.fThemeChangeListener != null) {
            InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
            this.fThemeChangeListener = null;
        }
        if (this.fCAProcessors != null) {
            for (IContentAssistProcessor cap : this.fCAProcessors) {
                if (!(cap instanceof ICommonContentAssistProcessor)) continue;
                ((ICommonContentAssistProcessor)cap).dispose();
            }
            this.fCAProcessors = null;
        }
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new CommonAnnotationHover(false){

            protected boolean isIncluded(Annotation annotation) {
                return CommonSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new RubyRegexpAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, CommonEditorPlugin.getDefault().getPreferenceStore())};
    }

    protected void applyTheme(final ContentAssistant assistant) {
        assistant.setProposalSelectorBackground(this.getThemeBackground());
        assistant.setProposalSelectorForeground(this.getThemeForeground());
        assistant.setProposalSelectorSelectionColor(this.getThemeSelection());
        assistant.setContextInformationPopupOrientation(21);
        assistant.setContextInformationPopupBackground(this.getThemeBackground());
        assistant.setContextInformationPopupForeground(this.getThemeForeground());
        this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("THEME_CHANGED")) {
                    assistant.setProposalSelectorBackground(CommonSourceViewerConfiguration.this.getThemeBackground());
                    assistant.setProposalSelectorForeground(CommonSourceViewerConfiguration.this.getThemeForeground());
                    assistant.setProposalSelectorSelectionColor(CommonSourceViewerConfiguration.this.getThemeSelection());
                    assistant.setContextInformationPopupBackground(CommonSourceViewerConfiguration.this.getThemeBackground());
                    assistant.setContextInformationPopupForeground(CommonSourceViewerConfiguration.this.getThemeForeground());
                }
            }
        };
        InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(this.fThemeChangeListener);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        String[] contentTypes;
        final ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.applyTheme(assistant);
        String[] stringArray = contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            IContentAssistProcessor processor = this.getContentAssistProcessor(sourceViewer, type);
            if (processor != null) {
                assistant.setContentAssistProcessor(processor, type);
                this.fCAProcessors.add(processor);
            }
            ++n2;
        }
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        if (this.fPreferenceStore != null) {
            this.setAutoActivationOptions(assistant);
            boolean autoInsert = this.fPreferenceStore.getBoolean("CONTENT_ASSIST_AUTO_INSERT");
            assistant.enableAutoInsert(autoInsert);
        }
        this.fAutoActivationListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                CommonSourceViewerConfiguration.this.setAutoActivationOptions(assistant);
            }
        };
        InstanceScope.INSTANCE.getNode("com.aptana.editor.common").addPreferenceChangeListener(this.fAutoActivationListener);
        return assistant;
    }

    private void setAutoActivationOptions(ContentAssistant assistant) {
        int delay = this.fPreferenceStore.getInt("CONTENT_ASSIST_DELAY");
        if (delay >= 0) {
            assistant.enableAutoActivation(true);
            assistant.setAutoActivationDelay(delay);
        } else {
            assistant.enableAutoActivation(false);
        }
    }

    protected IContentAssistProcessor getContentAssistProcessor(ISourceViewer sourceViewer, String contentType) {
        return new CommonContentAssistProcessor(this.getEditor());
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        String[][] contentTypes = this.getTopContentTypes();
        CommonMultiPassContentFormatter formatter = new CommonMultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        boolean masterSet = false;
        HashSet<String> addedFormatters = new HashSet<String>();
        String[][] stringArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType;
            String[] contentTypeArr = stringArray[n2];
            if (!masterSet && contentTypeArr[0].startsWith(CONTENTTYPE_HTML_PREFIX)) {
                if (ScriptFormatterManager.hasFormatterFor((String)CONTENTTYPE_HTML_PREFIX)) {
                    formatter.setMasterStrategy(CONTENTTYPE_HTML_PREFIX);
                    masterSet = true;
                    addedFormatters.add(CONTENTTYPE_HTML_PREFIX);
                } else {
                    IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Could not located an expected code formatter for ''{0}''", CONTENTTYPE_HTML_PREFIX));
                }
            }
            if (!addedFormatters.contains(contentType = contentTypeArr[contentTypeArr.length - 1]) && ScriptFormatterManager.hasFormatterFor((String)contentType)) {
                if (!masterSet) {
                    formatter.setMasterStrategy(contentType);
                    masterSet = true;
                } else {
                    formatter.setSlaveStrategy(contentType);
                }
            }
            ++n2;
        }
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new CommonDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("com.aptana.editor.ui.hyperlinkTarget", this.fTextEditor);
        return targets;
    }

    public String getIndent() {
        boolean useSpaces = this.fPreferenceStore.getBoolean("spacesForTabs");
        if (useSpaces) {
            int tabWidth = this.fPreferenceStore.getInt("tabWidth");
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < tabWidth) {
                buf.append(' ');
                ++i;
            }
            return buf.toString();
        }
        return "\t";
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.disableBackgroundReconciler) {
            return super.getPresentationReconciler(sourceViewer);
        }
        CommonPresentationReconciler reconciler = new CommonPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        return reconciler;
    }

    protected final Collection<String> getSpellingContentTypes(ISourceViewer sourceViewer) {
        HashSet<String> set = new HashSet<String>();
        IContentTypeTranslator contentTypeTranslator = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        String topContentType = this.getTopContentTypes()[0][0];
        String[] stringArray = this.getConfiguredContentTypes(sourceViewer);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            if (CommonEditorPlugin.getDefault().getSpellingPreferences().isSpellingEnabledFor(contentTypeTranslator.translate(new QualifiedContentType(topContentType, contentType)))) {
                set.add(contentType);
            }
            ++n2;
        }
        return Collections.unmodifiableCollection(set);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new ThemedInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    protected Color getThemeBackground() {
        RGB bg = this.getCurrentTheme().getBackground();
        return ThemePlugin.getDefault().getColorManager().getColor(bg);
    }

    protected Color getThemeForeground() {
        RGB bg = this.getCurrentTheme().getForeground();
        return ThemePlugin.getDefault().getColorManager().getColor(bg);
    }

    protected Color getThemeSelection() {
        RGB bg = this.getCurrentTheme().getSelectionAgainstBG();
        return ThemePlugin.getDefault().getColorManager().getColor(bg);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new TextHover(sourceViewer);
    }

    protected IInformationControl createTextHoverInformationControl(Shell parent, String statusFieldText) {
        return new ThemedInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), statusFieldText);
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, true);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new CommonAnnotationHover(true){

            protected boolean isIncluded(Annotation annotation) {
                return CommonSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fTextEditor != null && this.fTextEditor.isEditable()) {
            IBatchReconcilingStrategy reconcilingStrategy = new CommonReconcilingStrategy(this.fTextEditor);
            if (EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
                SpellingService spellingService = EditorsUI.getSpellingService();
                Collection<String> spellingContentTypes = this.getSpellingContentTypes(sourceViewer);
                if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) != null && !spellingContentTypes.isEmpty()) {
                    reconcilingStrategy = new CompositeReconcilingStrategy(new IReconcilingStrategy[]{reconcilingStrategy, new MultiRegionSpellingReconcileStrategy(sourceViewer, spellingService, this.getConfiguredDocumentPartitioning(sourceViewer), spellingContentTypes)});
                }
            }
            CommonReconciler reconciler = new CommonReconciler((IReconcilingStrategy)reconcilingStrategy);
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setIsAllowedToModifyDocument(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            this.fReconciler = reconciler;
            return this.fReconciler;
        }
        return null;
    }

    protected AbstractThemeableEditor getEditor() {
        return this.fTextEditor;
    }

    public void forceReconcile() {
        if (this.fReconciler != null) {
            this.fReconciler.forceReconciling();
        }
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        RGB rgb = this.getCurrentTheme().getForegroundAsRGB("hyperlink");
        return new MultipleHyperlinkPresenter(rgb);
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    private List<TextHoverDescriptor> getEnabledTextHoverDescriptors(ITextViewer textViewer, int offset) {
        ArrayList<TextHoverDescriptor> result = new ArrayList<TextHoverDescriptor>();
        if (this.fTextEditor == null) {
            return result;
        }
        try {
            IEditorInput editorInput;
            QualifiedContentType contentType = CommonEditorPlugin.getDefault().getDocumentScopeManager().getContentType(textViewer.getDocument(), offset);
            EvaluationContext context = new EvaluationContext(null, (Object)textViewer);
            IWorkbenchPartSite site = this.fTextEditor.getSite();
            if (site != null) {
                context.addVariable("activeEditorId", (Object)site.getId());
            }
            if ((editorInput = this.fTextEditor.getEditorInput()) != null) {
                context.addVariable("activeEditorInput", (Object)editorInput);
            }
            for (TextHoverDescriptor descriptor : TextHoverDescriptor.getContributedHovers()) {
                if (!descriptor.isEnabledFor(contentType, (IEvaluationContext)context)) continue;
                result.add(descriptor);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Collections.sort(result);
        return result;
    }

    private class TextHover
    extends DefaultTextHover
    implements ITextHoverExtension,
    ITextHoverExtension2 {
        private ITextHover activeTextHover;

        public TextHover(ISourceViewer sourceViewer) {
            super(sourceViewer);
        }

        public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
            String defaultInfo;
            if (this.activeTextHover != null) {
                Object info = null;
                if (this.activeTextHover instanceof AbstractCommonTextHover) {
                    AbstractCommonTextHover commonHover = (AbstractCommonTextHover)this.activeTextHover;
                    commonHover.setEditor((IEditorPart)CommonSourceViewerConfiguration.this.getEditor());
                }
                if ((info = this.activeTextHover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)this.activeTextHover).getHoverInfo2(textViewer, hoverRegion) : this.activeTextHover.getHoverInfo(textViewer, hoverRegion)) != null) {
                    return info;
                }
            }
            if ((defaultInfo = super.getHoverInfo(textViewer, hoverRegion)) != null) {
                return new SimpleTextHover(defaultInfo, null).getHoverInfo2(textViewer, hoverRegion);
            }
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            this.activeTextHover = null;
            List descriptors = CommonSourceViewerConfiguration.this.getEnabledTextHoverDescriptors(textViewer, offset);
            for (TextHoverDescriptor descriptor : descriptors) {
                ITextHover textHover = descriptor.createTextHover();
                IRegion region = null;
                if (textHover != null) {
                    region = textHover.getHoverRegion(textViewer, offset);
                }
                if (region == null || descriptors.size() > 1 && (textHover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)textHover).getHoverInfo2(textViewer, region) == null : textHover.getHoverInfo(textViewer, region) == null)) continue;
                this.activeTextHover = textHover;
                return region;
            }
            return super.getHoverRegion(textViewer, offset);
        }

        public IInformationControlCreator getHoverControlCreator() {
            if (this.activeTextHover instanceof ITextHoverExtension) {
                return ((ITextHoverExtension)this.activeTextHover).getHoverControlCreator();
            }
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return CommonSourceViewerConfiguration.this.createTextHoverInformationControl(parent, EditorsUI.getTooltipAffordanceString());
                }
            };
        }

        protected boolean isIncluded(Annotation annotation) {
            return CommonSourceViewerConfiguration.this.isShownInText(annotation);
        }
    }
}

